#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "db.h"

char *names[] = { "last name", "first name", "rank", "serial number", "addr" };
db_datum_type_t types[] = { DBD_STR, DBD_STR, DBD_STR, DBD_INT, DBD_MAC };

int
main(int argc, char **argv)
{
  db_database_ptr_t dp;
  db_table_ptr_t tp;
  db_datum_t row[5];
  db_datum_t **qres;
  int nres;
  int rc;
  int i;

  system("rm -r /tmp/testdb");

  rc = db_create_database("/tmp", "testdb");
  if (rc == -1) {
    fprintf(stderr, "database creation failed\n");
    exit(1);
  }

  dp = db_open_database("/tmp", "testdb", 1);
  if (dp == NULL) {
    fprintf(stderr, "database open failed\n");
    exit(1);
  }

  rc = db_create_table(dp, "table1", 5, names, types);
  if (rc == -1) {
    fprintf(stderr, "table creation failed\n");
    exit(1);
  }

  tp = db_open_table(dp, "table1");
  if (tp == NULL) {
    fprintf(stderr, "table open failed\n");
    exit(1);
  }

  for (i=0; i<5; ++i) row[i].type = types[i];

  row[0].dbd_str = "daley";
  row[1].dbd_str = "john";
  row[2].dbd_str = "admiral";
  row[3].dbd_int = 80137;
  memcpy(row[4].dbd_mac, "123456", 6);
  db_add_row(tp, row);

  row[0].dbd_str = "gallatin";
  row[1].dbd_str = "andrew";
  row[2].dbd_str = "general";
  row[3].dbd_int = -1;
  memcpy(row[4].dbd_mac, "abcdef", 6);
  db_add_row(tp, row);

  row[0].dbd_str = "seitz";
  row[1].dbd_str = "charles";
  row[2].dbd_str = "general";
  row[3].dbd_int = -17;
  memcpy(row[4].dbd_mac, "zyxwvu", 6);
  db_add_row(tp, row);

  rc = db_flush_table(tp);
  if (rc == -1) {
    perror("flushing");
    exit(1);
  }

  /* try out a query */
  db_simple_query(tp, 2, row+2, &qres, &nres);
  printf("%d generals:\n", nres);
  for (i=0; i<nres; ++i) {
    printf("\t%s %s\n", qres[i][1].dbd_str, qres[i][0].dbd_str);
  }
  db_free_query_res(tp, qres, nres);

  db_close_table(tp);
  db_close_database(dp);

  return 0;
}
